<?php
// verify.php
// Presents Google reCAPTCHA v2 to the visitor. On successful server-side verification
// the page redirects immediately to index.php (no click required).
// Replace YOUR_RECAPTCHA_SITE_KEY and YOUR_RECAPTCHA_SECRET_KEY with your keys.

$siteKey   = '6Ld7v_ErAAAAADBNeVwc08OefsJ92k602QYXoG6c';
$secretKey = '6Ld7v_ErAAAAANl2K2zuzO6iZE6wtCj6qzKOrgyt';

$captcha_success = false;
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $recaptcha_response = $_POST['g-recaptcha-response'] ?? '';

    if (!$recaptcha_response) {
        $error_message = 'reCAPTCHA response missing. Please try again.';
    } else {
        // Verify with Google (server-side)
        $verify_url = 'https://www.google.com/recaptcha/api/siteverify';
        $data = http_build_query([
            'secret'   => $secretKey,
            'response' => $recaptcha_response,
            'remoteip' => $_SERVER['REMOTE_ADDR'] ?? ''
        ]);

        $options = [
            'http' => [
                'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
                'method'  => 'POST',
                'content' => $data,
                'timeout' => 10
            ]
        ];
        $context  = stream_context_create($options);
        $result = @file_get_contents($verify_url, false, $context);

        if ($result === false) {
            $error_message = 'Failed to validate captcha (network error). Please try again.';
        } else {
            $json = json_decode($result, true);
            if (!empty($json['success'])) {
                $captcha_success = true;
            } else {
                $error_message = 'reCAPTCHA verification failed. Try again.';
            }
        }
    }

    if ($captcha_success) {
        // Redirect immediately to index.php (server-side redirect)
        $redirect_target = 'index.php';
        header('Location: ' . $redirect_target);
        // fallback HTML redirect in case headers already sent
        echo '<!doctype html><html><head>';
        echo '<meta http-equiv="refresh" content="0;url=' . htmlspecialchars($redirect_target, ENT_QUOTES) . '">';
        echo '<script>window.location.href = ' . json_encode($redirect_target) . ';</script>';
        echo '</head><body>If you are not redirected automatically, <a href="' . htmlspecialchars($redirect_target, ENT_QUOTES) . '">click here</a>.</body></html>';
        exit;
    }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Security Verification</title>
  <style>
    body { font-family: Arial, Helvetica, sans-serif; background:#f1f3f6; margin:0; padding:40px 0; }
    .container { max-width:700px; margin:auto; background:#fff; border:1px solid #d3d3d3; border-radius:5px; padding:30px; text-align:center; }
    .header { color:#0b3d91; font-size:22px; font-weight:700; margin-bottom:12px; }
    button { background:#0b3d91; color:#fff; border:none; padding:10px 16px; border-radius:4px; cursor:pointer; font-size:15px; }
    .err { color:#b00020; margin-top:12px; font-weight:700; }
  </style>
  <script src="https://www.google.com/recaptcha/api.js" async defer></script>
</head>
<body>
  <div class="container">
    <div class="header">Security Verification</div>

    <p>Please confirm you are not a robot to continue to the site.</p>

    <?php if (!empty($error_message)): ?>
      <div class="err"><?php echo htmlspecialchars($error_message); ?></div>
      <br>
    <?php endif; ?>

    <form method="POST" action="">
      <div class="g-recaptcha" data-sitekey="<?php echo htmlspecialchars($siteKey, ENT_QUOTES); ?>"></div>
      <br>
      <button type="submit">Verify & Continue</button>
    </form>
  </div>
</body>
</html>
